<?php

namespace Modules\GlobalSetting\app\Enums;

use Illuminate\Support\Collection;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

enum WebsiteSettingEnum: string {

    public static function allTimeZones(): Collection {
        $timezones = [
            (object) ['name' => 'Africa/Abidjan'],
            (object) ['name' => 'Africa/Accra'],
            (object) ['name' => 'Africa/Addis_Ababa'],
            (object) ['name' => 'Africa/Algiers'],
            (object) ['name' => 'Africa/Asmara'],
            (object) ['name' => 'Africa/Bamako'],
            (object) ['name' => 'Africa/Bangui'],
            (object) ['name' => 'Africa/Banjul'],
            (object) ['name' => 'Africa/Bissau'],
            (object) ['name' => 'Africa/Blantyre'],
            (object) ['name' => 'Africa/Brazzaville'],
            (object) ['name' => 'Africa/Bujumbura'],
            (object) ['name' => 'Africa/Cairo'],
            (object) ['name' => 'Africa/Casablanca'],
            (object) ['name' => 'Africa/Ceuta'],
            (object) ['name' => 'Africa/Conakry'],
            (object) ['name' => 'Africa/Dakar'],
            (object) ['name' => 'Africa/Dar_es_Salaam'],
            (object) ['name' => 'Africa/Djibouti'],
            (object) ['name' => 'Africa/Douala'],
            (object) ['name' => 'Africa/El_Aaiun'],
            (object) ['name' => 'Africa/Freetown'],
            (object) ['name' => 'Africa/Gaborone'],
            (object) ['name' => 'Africa/Harare'],
            (object) ['name' => 'Africa/Johannesburg'],
            (object) ['name' => 'Africa/Juba'],
            (object) ['name' => 'Africa/Kampala'],
            (object) ['name' => 'Africa/Khartoum'],
            (object) ['name' => 'Africa/Kigali'],
            (object) ['name' => 'Africa/Kinshasa'],
            (object) ['name' => 'Africa/Lagos'],
            (object) ['name' => 'Africa/Libreville'],
            (object) ['name' => 'Africa/Lome'],
            (object) ['name' => 'Africa/Luanda'],
            (object) ['name' => 'Africa/Lubumbashi'],
            (object) ['name' => 'Africa/Lusaka'],
            (object) ['name' => 'Africa/Malabo'],
            (object) ['name' => 'Africa/Maputo'],
            (object) ['name' => 'Africa/Maseru'],
            (object) ['name' => 'Africa/Mbabane'],
            (object) ['name' => 'Africa/Mogadishu'],
            (object) ['name' => 'Africa/Monrovia'],
            (object) ['name' => 'Africa/Nairobi'],
            (object) ['name' => 'Africa/Ndjamena'],
            (object) ['name' => 'Africa/Niamey'],
            (object) ['name' => 'Africa/Nouakchott'],
            (object) ['name' => 'Africa/Ouagadougou'],
            (object) ['name' => 'Africa/Porto-Novo'],
            (object) ['name' => 'Africa/Sao_Tome'],
            (object) ['name' => 'Africa/Tripoli'],
            (object) ['name' => 'Africa/Tunis'],
            (object) ['name' => 'Africa/Windhoek'],
            (object) ['name' => 'America/Adak'],
            (object) ['name' => 'America/Anchorage'],
            (object) ['name' => 'America/Anguilla'],
            (object) ['name' => 'America/Antigua'],
            (object) ['name' => 'America/Araguaina'],
            (object) ['name' => 'America/Argentina/Buenos_Aires'],
            (object) ['name' => 'America/Argentina/Catamarca'],
            (object) ['name' => 'America/Argentina/Cordoba'],
            (object) ['name' => 'America/Argentina/Jujuy'],
            (object) ['name' => 'America/Argentina/La_Rioja'],
            (object) ['name' => 'America/Argentina/Mendoza'],
            (object) ['name' => 'America/Argentina/Rio_Gallegos'],
            (object) ['name' => 'America/Argentina/Salta'],
            (object) ['name' => 'America/Argentina/San_Juan'],
            (object) ['name' => 'America/Argentina/San_Luis'],
            (object) ['name' => 'America/Argentina/Tucuman'],
            (object) ['name' => 'America/Argentina/Ushuaia'],
            (object) ['name' => 'America/Aruba'],
            (object) ['name' => 'America/Asuncion'],
            (object) ['name' => 'America/Atikokan'],
            (object) ['name' => 'America/Bahia'],
            (object) ['name' => 'America/Bahia_Banderas'],
            (object) ['name' => 'America/Barbados'],
            (object) ['name' => 'America/Belem'],
            (object) ['name' => 'America/Belize'],
            (object) ['name' => 'America/Blanc-Sablon'],
            (object) ['name' => 'America/Boa_Vista'],
            (object) ['name' => 'America/Bogota'],
            (object) ['name' => 'America/Boise'],
            (object) ['name' => 'America/Cambridge_Bay'],
            (object) ['name' => 'America/Campo_Grande'],
            (object) ['name' => 'America/Cancun'],
            (object) ['name' => 'America/Caracas'],
            (object) ['name' => 'America/Cayenne'],
            (object) ['name' => 'America/Cayman'],
            (object) ['name' => 'America/Chicago'],
            (object) ['name' => 'America/Chihuahua'],
            (object) ['name' => 'America/Costa_Rica'],
            (object) ['name' => 'America/Creston'],
            (object) ['name' => 'America/Cuiaba'],
            (object) ['name' => 'America/Curacao'],
            (object) ['name' => 'America/Danmarkshavn'],
            (object) ['name' => 'America/Dawson'],
            (object) ['name' => 'America/Dawson_Creek'],
            (object) ['name' => 'America/Denver'],
            (object) ['name' => 'America/Detroit'],
            (object) ['name' => 'America/Dominica'],
            (object) ['name' => 'America/Edmonton'],
            (object) ['name' => 'America/Eirunepe'],
            (object) ['name' => 'America/El_Salvador'],
            (object) ['name' => 'America/Fort_Nelson'],
            (object) ['name' => 'America/Fortaleza'],
            (object) ['name' => 'America/Glace_Bay'],
            (object) ['name' => 'America/Goose_Bay'],
            (object) ['name' => 'America/Grand_Turk'],
            (object) ['name' => 'America/Grenada'],
            (object) ['name' => 'America/Guadeloupe'],
            (object) ['name' => 'America/Guatemala'],
            (object) ['name' => 'America/Guayaquil'],
            (object) ['name' => 'America/Guyana'],
            (object) ['name' => 'America/Halifax'],
            (object) ['name' => 'America/Havana'],
            (object) ['name' => 'America/Hermosillo'],
            (object) ['name' => 'America/Indiana/Indianapolis'],
            (object) ['name' => 'America/Indiana/Knox'],
            (object) ['name' => 'America/Indiana/Marengo'],
            (object) ['name' => 'America/Indiana/Petersburg'],
            (object) ['name' => 'America/Indiana/Tell_City'],
            (object) ['name' => 'America/Indiana/Vevay'],
            (object) ['name' => 'America/Indiana/Vincennes'],
            (object) ['name' => 'America/Indiana/Winamac'],
            (object) ['name' => 'America/Inuvik'],
            (object) ['name' => 'America/Iqaluit'],
            (object) ['name' => 'America/Jamaica'],
            (object) ['name' => 'America/Juneau'],
            (object) ['name' => 'America/Kentucky/Louisville'],
            (object) ['name' => 'America/Kentucky/Monticello'],
            (object) ['name' => 'America/Kralendijk'],
            (object) ['name' => 'America/La_Paz'],
            (object) ['name' => 'America/Lima'],
            (object) ['name' => 'America/Los_Angeles'],
            (object) ['name' => 'America/Lower_Princes'],
            (object) ['name' => 'America/Maceio'],
            (object) ['name' => 'America/Nuuk'],
            (object) ['name' => 'America/Ojinaga'],
            (object) ['name' => 'America/Panama'],
            (object) ['name' => 'America/Pangnirtung'],
            (object) ['name' => 'America/Paramaribo'],
            (object) ['name' => 'America/Phoenix'],
            (object) ['name' => 'America/Port-au-Prince'],
            (object) ['name' => 'America/Port_of_Spain'],
            (object) ['name' => 'America/Porto_Velho'],
            (object) ['name' => 'America/Puerto_Rico'],
            (object) ['name' => 'America/Punta_Arenas'],
            (object) ['name' => 'America/Rainy_River'],
            (object) ['name' => 'America/Rankin_Inlet'],
            (object) ['name' => 'America/Recife'],
            (object) ['name' => 'America/Regina'],
            (object) ['name' => 'America/Resolute'],
            (object) ['name' => 'America/Rio_Branco'],
            (object) ['name' => 'America/Santarem'],
            (object) ['name' => 'America/Santiago'],
            (object) ['name' => 'America/Santo_Domingo'],
            (object) ['name' => 'America/Sao_Paulo'],
            (object) ['name' => 'America/Scoresbysund'],
            (object) ['name' => 'America/Sitka'],
            (object) ['name' => 'America/St_Barthelemy'],
            (object) ['name' => 'America/St_Johns'],
            (object) ['name' => 'America/St_Kitts'],
            (object) ['name' => 'America/St_Lucia'],
            (object) ['name' => 'America/St_Thomas'],
            (object) ['name' => 'America/St_Vincent'],
            (object) ['name' => 'America/Swift_Current'],
            (object) ['name' => 'America/Tegucigalpa'],
            (object) ['name' => 'America/Thule'],
            (object) ['name' => 'America/Thunder_Bay'],
            (object) ['name' => 'America/Tijuana'],
            (object) ['name' => 'America/Toronto'],
            (object) ['name' => 'America/Tortola'],
            (object) ['name' => 'America/Vancouver'],
            (object) ['name' => 'America/Whitehorse'],
            (object) ['name' => 'America/Winnipeg'],
            (object) ['name' => 'America/Yakutat'],
            (object) ['name' => 'America/Yellowknife'],
            (object) ['name' => 'Antarctica/Casey'],
            (object) ['name' => 'Antarctica/Davis'],
            (object) ['name' => 'Antarctica/DumontDUrville'],
            (object) ['name' => 'Antarctica/Macquarie'],
            (object) ['name' => 'Antarctica/Mawson'],
            (object) ['name' => 'Antarctica/McMurdo'],
            (object) ['name' => 'Antarctica/Palmer'],
            (object) ['name' => 'Antarctica/Rothera'],
            (object) ['name' => 'Antarctica/Syowa'],
            (object) ['name' => 'Antarctica/Troll'],
            (object) ['name' => 'Antarctica/Vostok'],
            (object) ['name' => 'Arctic/Longyearbyen'],
            (object) ['name' => 'Asia/Aden'],
            (object) ['name' => 'Asia/Almaty'],
            (object) ['name' => 'Asia/Amman'],
            (object) ['name' => 'Asia/Anadyr'],
            (object) ['name' => 'Asia/Aqtau'],
            (object) ['name' => 'Asia/Aqtobe'],
            (object) ['name' => 'Asia/Ashgabat'],
            (object) ['name' => 'Asia/Atyrau'],
            (object) ['name' => 'Asia/Baghdad'],
            (object) ['name' => 'Asia/Bahrain'],
            (object) ['name' => 'Asia/Baku'],
            (object) ['name' => 'Asia/Bangkok'],
            (object) ['name' => 'Asia/Barnaul'],
            (object) ['name' => 'Asia/Beirut'],
            (object) ['name' => 'Asia/Bishkek'],
            (object) ['name' => 'Asia/Brunei'],
            (object) ['name' => 'Asia/Chita'],
            (object) ['name' => 'Asia/Choibalsan'],
            (object) ['name' => 'Asia/Colombo'],
            (object) ['name' => 'Asia/Damascus'],
            (object) ['name' => 'Asia/Dhaka'],
            (object) ['name' => 'Asia/Dili'],
            (object) ['name' => 'Asia/Dubai'],
            (object) ['name' => 'Asia/Dushanbe'],
            (object) ['name' => 'Asia/Famagusta'],
            (object) ['name' => 'Asia/Gaza'],
            (object) ['name' => 'Asia/Hebron'],
            (object) ['name' => 'Asia/Ho_Chi_Minh'],
            (object) ['name' => 'Asia/Hong_Kong'],
            (object) ['name' => 'Asia/Hovd'],
            (object) ['name' => 'Asia/Irkutsk'],
            (object) ['name' => 'Asia/Jakarta'],
            (object) ['name' => 'Asia/Jayapura'],
            (object) ['name' => 'Asia/Jerusalem'],
            (object) ['name' => 'Asia/Kabul'],
            (object) ['name' => 'Asia/Kamchatka'],
            (object) ['name' => 'Asia/Karachi'],
            (object) ['name' => 'Asia/Kathmandu'],
            (object) ['name' => 'Asia/Khandyga'],
            (object) ['name' => 'Asia/Kolkata'],
            (object) ['name' => 'Asia/Krasnoyarsk'],
            (object) ['name' => 'Asia/Kuala_Lumpur'],
            (object) ['name' => 'Asia/Kuching'],
            (object) ['name' => 'Asia/Kuwait'],
            (object) ['name' => 'Asia/Macau'],
            (object) ['name' => 'Asia/Magadan'],
            (object) ['name' => 'Asia/Makassar'],
            (object) ['name' => 'Asia/Manila'],
            (object) ['name' => 'Asia/Muscat'],
            (object) ['name' => 'Asia/Nicosia'],
            (object) ['name' => 'Asia/Novokuznetsk'],
            (object) ['name' => 'Asia/Novosibirsk'],
            (object) ['name' => 'Asia/Omsk'],
            (object) ['name' => 'Asia/Oral'],
            (object) ['name' => 'Asia/Phnom_Penh'],
            (object) ['name' => 'Asia/Pontianak'],
            (object) ['name' => 'Asia/Pyongyang'],
            (object) ['name' => 'Asia/Qatar'],
            (object) ['name' => 'Asia/Qostanay'],
            (object) ['name' => 'Asia/Qyzylorda'],
            (object) ['name' => 'Asia/Riyadh'],
            (object) ['name' => 'Asia/Sakhalin'],
            (object) ['name' => 'Asia/Samarkand'],
            (object) ['name' => 'Asia/Seoul'],
            (object) ['name' => 'Asia/Shanghai'],
            (object) ['name' => 'Asia/Singapore'],
            (object) ['name' => 'Asia/Srednekolymsk'],
            (object) ['name' => 'Asia/Taipei'],
            (object) ['name' => 'Asia/Tashkent'],
            (object) ['name' => 'Asia/Tbilisi'],
            (object) ['name' => 'Asia/Tehran'],
            (object) ['name' => 'Asia/Thimphu'],
            (object) ['name' => 'Asia/Tokyo'],
            (object) ['name' => 'Asia/Tomsk'],
            (object) ['name' => 'Asia/Ulaanbaatar'],
            (object) ['name' => 'Asia/Urumqi'],
            (object) ['name' => 'Asia/Ust-Nera'],
            (object) ['name' => 'Asia/Vientiane'],
            (object) ['name' => 'Asia/Vladivostok'],
            (object) ['name' => 'Asia/Yakutsk'],
            (object) ['name' => 'Asia/Yangon'],
            (object) ['name' => 'Asia/Yekaterinburg'],
            (object) ['name' => 'Asia/Yerevan'],
            (object) ['name' => 'Atlantic/Azores'],
            (object) ['name' => 'Atlantic/Bermuda'],
            (object) ['name' => 'Atlantic/Canary'],
            (object) ['name' => 'Atlantic/Cape_Verde'],
            (object) ['name' => 'Atlantic/Faroe'],
            (object) ['name' => 'Atlantic/Madeira'],
            (object) ['name' => 'Atlantic/Reykjavik'],
            (object) ['name' => 'Atlantic/South_Georgia'],
            (object) ['name' => 'Atlantic/St_Helena'],
            (object) ['name' => 'Atlantic/Stanley'],
            (object) ['name' => 'Australia/Adelaide'],
            (object) ['name' => 'Australia/Brisbane'],
            (object) ['name' => 'Australia/Broken_Hill'],
            (object) ['name' => 'Australia/Darwin'],
            (object) ['name' => 'Australia/Eucla'],
            (object) ['name' => 'Australia/Hobart'],
            (object) ['name' => 'Australia/Lindeman'],
            (object) ['name' => 'Australia/Lord_Howe'],
            (object) ['name' => 'Australia/Melbourne'],
            (object) ['name' => 'Australia/Perth'],
            (object) ['name' => 'Australia/Sydney'],
            (object) ['name' => 'Europe/Amsterdam'],
            (object) ['name' => 'Europe/Andorra'],
            (object) ['name' => 'Europe/Astrakhan'],
            (object) ['name' => 'Europe/Athens'],
            (object) ['name' => 'Europe/Belgrade'],
            (object) ['name' => 'Europe/Berlin'],
            (object) ['name' => 'Europe/Bratislava'],
            (object) ['name' => 'Europe/Brussels'],
            (object) ['name' => 'Europe/Bucharest'],
            (object) ['name' => 'Europe/Budapest'],
            (object) ['name' => 'Europe/Busingen'],
            (object) ['name' => 'Europe/Chisinau'],
            (object) ['name' => 'Europe/Copenhagen'],
            (object) ['name' => 'Europe/Dublin'],
            (object) ['name' => 'Europe/Gibraltar'],
            (object) ['name' => 'Europe/Guernsey'],
            (object) ['name' => 'Europe/Helsinki'],
            (object) ['name' => 'Europe/Isle_of_Man'],
            (object) ['name' => 'Europe/Istanbul'],
            (object) ['name' => 'Europe/Jersey'],
            (object) ['name' => 'Europe/Kaliningrad'],
            (object) ['name' => 'Europe/Kiev'],
            (object) ['name' => 'Europe/Kirov'],
            (object) ['name' => 'Europe/Lisbon'],
            (object) ['name' => 'Europe/Ljubljana'],
            (object) ['name' => 'Europe/London'],
            (object) ['name' => 'Europe/Luxembourg'],
            (object) ['name' => 'Europe/Madrid'],
            (object) ['name' => 'Europe/Malta'],
            (object) ['name' => 'Europe/Mariehamn'],
            (object) ['name' => 'Europe/Minsk'],
            (object) ['name' => 'Europe/Monaco'],
            (object) ['name' => 'Europe/Moscow'],
            (object) ['name' => 'Europe/Oslo'],
            (object) ['name' => 'Europe/Paris'],
            (object) ['name' => 'Europe/Podgorica'],
            (object) ['name' => 'Europe/Prague'],
            (object) ['name' => 'Europe/Riga'],
            (object) ['name' => 'Europe/Rome'],
            (object) ['name' => 'Europe/Samara'],
            (object) ['name' => 'Europe/San_Marino'],
            (object) ['name' => 'Europe/Sarajevo'],
            (object) ['name' => 'Europe/Saratov'],
            (object) ['name' => 'Europe/Simferopol'],
            (object) ['name' => 'Europe/Skopje'],
            (object) ['name' => 'Europe/Sofia'],
            (object) ['name' => 'Europe/Stockholm'],
            (object) ['name' => 'Europe/Tallinn'],
            (object) ['name' => 'Europe/Tirane'],
            (object) ['name' => 'Europe/Ulyanovsk'],
            (object) ['name' => 'Europe/Uzhgorod'],
            (object) ['name' => 'Europe/Vaduz'],
            (object) ['name' => 'Europe/Vatican'],
            (object) ['name' => 'Europe/Vienna'],
            (object) ['name' => 'Europe/Vilnius'],
            (object) ['name' => 'Europe/Volgograd'],
            (object) ['name' => 'Europe/Warsaw'],
            (object) ['name' => 'Europe/Zagreb'],
            (object) ['name' => 'Europe/Zaporozhye'],
            (object) ['name' => 'Europe/Zurich'],
            (object) ['name' => 'Indian/Antananarivo'],
            (object) ['name' => 'Indian/Chagos'],
            (object) ['name' => 'Indian/Christmas'],
            (object) ['name' => 'Indian/Cocos'],
            (object) ['name' => 'Indian/Comoro'],
            (object) ['name' => 'Indian/Kerguelen'],
            (object) ['name' => 'Indian/Mahe'],
            (object) ['name' => 'Indian/Maldives'],
            (object) ['name' => 'Indian/Mauritius'],
            (object) ['name' => 'Indian/Mayotte'],
            (object) ['name' => 'Indian/Reunion'],
            (object) ['name' => 'Pacific/Apia'],
            (object) ['name' => 'Pacific/Auckland'],
            (object) ['name' => 'Pacific/Bougainville'],
            (object) ['name' => 'Pacific/Chatham'],
            (object) ['name' => 'Pacific/Chuuk'],
            (object) ['name' => 'Pacific/Easter'],
            (object) ['name' => 'Pacific/Efate'],
            (object) ['name' => 'Pacific/Enderbury'],
            (object) ['name' => 'Pacific/Fakaofo'],
            (object) ['name' => 'Pacific/Fiji'],
            (object) ['name' => 'Pacific/Funafuti'],
            (object) ['name' => 'Pacific/Galapagos'],
            (object) ['name' => 'Pacific/Gambier'],
            (object) ['name' => 'Pacific/Guadalcanal'],
            (object) ['name' => 'Pacific/Guam'],
            (object) ['name' => 'Pacific/Honolulu'],
            (object) ['name' => 'Pacific/Kiritimati'],
            (object) ['name' => 'Pacific/Kosrae'],
            (object) ['name' => 'Pacific/Kwajalein'],
            (object) ['name' => 'Pacific/Majuro'],
            (object) ['name' => 'Pacific/Marquesas'],
            (object) ['name' => 'Pacific/Midway'],
            (object) ['name' => 'Pacific/Nauru'],
            (object) ['name' => 'Pacific/Niue'],
            (object) ['name' => 'Pacific/Norfolk'],
            (object) ['name' => 'Pacific/Noumea'],
            (object) ['name' => 'Pacific/Pago_Pago'],
            (object) ['name' => 'Pacific/Palau'],
            (object) ['name' => 'Pacific/Pitcairn'],
            (object) ['name' => 'Pacific/Pohnpei'],
            (object) ['name' => 'Pacific/Port_Moresby'],
            (object) ['name' => 'Pacific/Rarotonga'],
            (object) ['name' => 'Pacific/Saipan'],
            (object) ['name' => 'Pacific/Tahiti'],
            (object) ['name' => 'Pacific/Tarawa'],
            (object) ['name' => 'Pacific/Tongatapu'],
            (object) ['name' => 'Pacific/Wake'],
            (object) ['name' => 'Pacific/Wallis'],
            (object) ['name' => 'UTC'],
        ];

        return collect( $timezones );
    }

    public static function allTimeFormat() :array
    {
        return [
            'H:i:s' => 'H:i:s (24-hour format with leading zeros, e.g., ' . self::now()->format('H:i:s') . ')',
            'h:i:s A' => 'h:i:s A (12-hour format with leading zeros and AM/PM, e.g., ' . self::now()->format('h:i:s A') . ')',
            'h:i A' => 'h:i A (12-hour format with leading zeros and AM/PM, e.g., ' . self::now()->format('h:i A') . ')',
            'H:i' => 'H:i (24-hour format with leading zeros, e.g., ' . self::now()->format('H:i') . ')',
            'g:i:s A' => 'g:i:s A (12-hour format without leading zeros and AM/PM, e.g., ' . self::now()->format('g:i:s A') . ')',
            'g:i A' => 'g:i A (12-hour format without leading zeros and AM/PM, e.g., ' . self::now()->format('g:i A') . ')',
            'h:i A' => 'h:i A (12-hour format with leading zeros and AM/PM, e.g., ' . self::now()->format('h:i A') . ')',
        ];
    }

    public static function allDateFormat() :array
    {
        return [
            'Y-m-d' => 'Y-m-d (Year-month-day, e.g., ' . self::now()->format('Y-m-d') . ')',
            'd-m-Y' => 'd-m-Y (Day-month-year, e.g., ' . self::now()->format('d-m-Y') . ')',
            'm/d/Y' => 'm/d/Y (Month/day/year, e.g., ' . self::now()->format('m/d/Y') . ')',
            'd/m/Y' => 'd/m/Y (Day/month/year, e.g., ' . self::now()->format('d/m/Y') . ')',
            'Y年m月d日' => 'Y年m月d日 (Year年month月day日, e.g., ' . self::now()->format('Y年m月d日') . ')',
            'Y/m/d' => 'Y/m/d (Year/month/day, e.g., ' . self::now()->format('Y/m/d') . ')',
            'd.m.Y' => 'd.m.Y (Day.month.Year, e.g., ' . self::now()->format('d.m.Y') . ')',
            'l, d F Y' => 'l, d F Y (Full textual representation of the day, day of the month, month, year, e.g., ' . self::now()->format('l, d F Y') . ')',
            'd-M-Y' => 'd-M-Y (Day-Month-Year, e.g., ' . self::now()->format('d-M-Y') . ')',
            'Y/m/d D' => 'Y/m/d D (Year/month/day Day, e.g., ' . self::now()->format('Y/m/d D') . ')',
            'jS F Y' => 'jS F Y (Day without leading zeros, month, year, e.g., ' . self::now()->format('jS F Y') . ')',
            'D, M jS Y' => 'D, M jS Y (Day, month, day without leading zeros, year, e.g., ' . self::now()->format('D, M jS Y') . ')',
        ];
    }

    public static function now()
    {
        return Carbon::now(config('app.timezone'));
    }

}
