<?php

namespace Modules\Blog\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Blog\Database\factories\BlogCategoryTranslationFactory;

class BlogCategoryTranslation extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'blog_id',
        'lang_code',
        'title',
        'short_description'
    ];

    public function category(): ?BelongsTo
    {
        return $this->belongsTo(BlogCategory::class,'blog_category_id');
    }
}
